<?php
    /*
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $data1MeseFa       = date("Y-m-d h:i:sa", strtotime("-1 Months"));
    $queryUtentiAttivi = "SELECT * FROM geec_utenti WHERE ultimoLogin > '$data1MeseFa'";
    $risUtentiAttivi   = $geecomDb->eseguiQueryLettura($queryUtentiAttivi);
    $utentiAttivi      = $risUtentiAttivi->num_rows;
    $numeroUtenti      = $geecomDb->contaRigheTabella("geec_utenti");
    $datiStatistiche   = $geecomDb->leggiSingolaRiga("geecAd_statistiche",1);
    $numeroLogin       = $datiStatistiche["numeroLogin"];
    $loginOggi         = $datiStatistiche["loginOggi"];
    $datiUtilizzoPiattaforma = calcoloUtilizzoPiattaforma($numeroUtenti,$utentiAttivi);
?>


    <div class="form-row">
        <div class="col-lg-4 col-xl-3 form-group">
			<div class="card border-0 text-white bg-<?php echo $datiUtilizzoPiattaforma["classeBoxUtilizzo"]; ?> p-3 mb-2 seo small">
				 <div class="d-flex justify-content-between">
					 <div class="w-100">
						 <h6 class="mb-1"><i class="<?php echo $analisiSito["icona"]; ?>"></i> La percentuale di utilizzo è del <strong><?php echo $datiUtilizzoPiattaforma["percentualeUtilizzo"]; ?> %</strong></h6>
						 <span><?php echo $datiUtilizzoPiattaforma["fraseUtilizzo"]; ?> <i class="fas fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="La percentuale media di utilizzo delle aree riservate è 40%"></i></span>
					 </div>
					 <a class="btn btn-outline-light btn-sm align-self-center" href="statistiche.php">Dettagli</a>
				 </div>
			</div>
        </div>
		
		<div class="col-lg-8 col-xl-9">
			<div id="contatori" class="form-row row-cols-1 row-cols-lg-3">
				<div class="col">
					<div class="card border-0 p-3 mb-3 mb-md-0">
						<div class="d-flex align-items-center justify-content-between">
							<h6 class="text-primary mb-0 mr-3"><i class="fas fa-sign-in-alt mr-2"></i>Login</h6>
							<ul class="list-unstyled list-group list-group-horizontal m-0">
								<li class="list-group-item py-2"><b>Tot</b>: <?php echo $numeroLogin; ?></li>
								<li class="list-group-item py-2"><b>Oggi</b>: <?php echo $loginOggi; ?></li>
							 </ul>
						</div>
					</div>
				</div>	

				<div class="col">
					<div class="card border-0 p-3 mb-3 mb-md-0">
						<div class="d-flex align-items-center justify-content-between">
							<h6 class="text-primary mb-0 mr-3"><i class="far fa-comments mr-2"></i>Comunicazioni</h6>
							<ul class="list-unstyled list-group list-group-horizontal m-0">
								<li class="list-group-item py-2"><b>Tot</b>: <?php echo($geecomDb->contaRigheTabella("geecAd_comunicazioni")) ?></li>
							 </ul>
						</div>
					</div>
				</div>
				
				<div class="col">
					<div class="card border-0 p-3 mb-3 mb-md-0">
						<div class="d-flex align-items-center justify-content-between">
							<h6 class="text-primary mb-0 mr-3"><i class="far fa-user mr-2"></i>Utenti</h6>
							<ul class="list-unstyled list-group list-group-horizontal m-0">
								<li class="list-group-item py-2"><b>Attivi</b>: <?php echo($utentiAttivi) ?></li>
							 </ul>
						</div>
					</div>
				</div>
			</div><!-- /contatori -->
		</div>
    </div>
	
	<div class="form-row row-cols-1 row-cols-sm-2 row-cols-lg-4 mb-2">
		<div class="col form-group">
            <div class="card border-0 p-3 bg-primary text-light">
				<div class="d-flex justify-content-between">
					<div>
					<h5 class="mb-0"><i class="fas fa-user"></i> <?php echo $geecomDb->contaRigheTabella("geec_utenti"); ?></h5>
					<span>Utenti</span>
					</div>
					<div class="align-self-center">
						<a class="btn btn-light btn-sm aggiungi" href="creaContenuto.php?tipo=pagina">Nuovo</a>
						<a class="btn btn-outline-light btn-sm" href="gestioneContenuti.php?tipo=pagina">Vedi tutti</a>
					</div>
				</div>
            </div>
        </div>	
		
		<div class="col form-group">
            <div class="card border-0 p-3 bg-primary text-light">
				<div class="d-flex justify-content-between">
					<div>
					<h5 class="mb-0"><i class="fas fa-users"></i> <?php echo $geecomDb->contaRigheTabella("geec_gruppi"); ?></h5>
					<span>Gruppi</span>
					</div>
					<div class="align-self-center">
						<a class="btn btn-outline-light btn-sm" href="gestioneGruppi.php">Vedi tutti</a>
					</div>
				</div>
            </div>
        </div>
	
		<div class="col form-group">
            <div class="card border-0 p-3 bg-primary text-light">
				<div class="d-flex justify-content-between">
					<div>
					<h5 class="mb-0"><i class="fas fa-comments"></i> <?php echo $geecomDb->contaRigheTabella("geecAd_comunicazioni",array("tipo"=>"comunicazione")); ?></h5>
					<span>Comunicazioni</span>
					</div>
					<div class="align-self-center">
						<a class="btn btn-light btn-sm aggiungi" href="creaComunicazione.php">Nuova</a>
						<a class="btn btn-outline-light btn-sm" href="gestioneComunicazioni.php">Vedi tutte</a>
					</div>
				</div>
            </div>
        </div>	
		
		<div class="col form-group">
            <div class="card border-0 p-3 bg-primary text-light">
				<div class="d-flex justify-content-between">
					<div>
					<h5 class="mb-0"><i class="fas fa-columns"></i> <?php echo $geecomDb->contaRigheTabella("geecAd_contenuti"); ?></h5>
					<span>Pagine</span>
					</div>
					<div class="align-self-center">
						<a class="btn btn-light btn-sm aggiungi" href="creaContenuto.php">Nuova</a>
						<a class="btn btn-outline-light btn-sm" href="gestionePagine.php">Vedi tutte</a>
					</div>
				</div>
            </div>
        </div>
    </div>